#version 330
#extension GL_EXT_gpu_shader4 : enable
// Interactive Collatz with goodMod01.fsh  by rodolphito

//https://www.shadertoy.com/view/4syyzw
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

vec4 pi = vec4(0,2,4,8)*atan(1.0);

vec2 cdiv (vec2 a,vec2 b){return vec2(dot(a,b),a.y*b.x-a.x*b.y)/dot(b,b);}
vec2 cmul (vec2 a,vec2 b){return vec2(a.x*b.x-a.y*b.y,a.x*b.y+a.y*b.x);}
vec2 cmulj(vec2 z){return vec2(-z.y,z.x);}
vec2 cexp (vec2 z){return exp( z.x)*sin(z.y+pi.yx);}
vec2 cexpj(vec2 z){return exp(-z.y)*sin(z.x+pi.yx);}
vec2 cpow (float a,vec2 z){return pow(a, z.x)*sin(z.y+pi.yx);}
vec2 cpowj(float a,vec2 z){return pow(a,-z.y)*sin(z.x+pi.yx);}
vec2 csqr (vec2 z){return vec2(z.x*z.x-z.y*z.y,2.0*z.y*z.x);}
vec2 cinv (vec2 z){return vec2(z.x,-z.y)/dot(z,z);}
vec2 cPow (vec2 z,float n){return pow(length(z),n)*sin(atan(z.y,z.x)*n+pi.yx);}
vec2 cexpc(vec2 a, vec2 b)
{
    return cmul(cpow(dot(a,a),0.5*b),cexpj(atan(a.y,a.x)*b));
    //(a+bi)^(c+di)=(aa+bb)^((c+id)/2)*e^(i(c+id)arg(a+ib))
}

vec3 hsv2rgb(in vec3 c)
{
	return c.z*mix(vec3(1.0),0.5+0.5*sin(c.x+pi.xzw/3.0),c.y);
}

vec3 getcol(float a)
{
	vec3 c = sin(pi.w*vec3(a, a + 0.333, a + 0.666)) * 0.5 + 0.5;
    c += 0.01;
    return c * 0.05;
}

vec4 collatz(vec4 z, vec2 shift)
{
    vec2 k = cexpj(pi.z*z.xy);
    vec2 zd = z.xy*1.25+vec2(0.5,0.0);
    return vec4(
          z.xy*1.75+vec2(0.5,0.0) - cmul(k,zd) + shift,
         cmul(z.zw,vec2(1.75,0.0) - cmul(k,zd*pi.z-vec2(0.0,1.25)))
    );
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 p = 7.0*(gl_FragCoord.xy-iResolution.xy*0.5)/iResolution.x;
    vec4 z = vec4(p,1.0,0.0);
    vec2 shift = 1.0 - 2.0 * iMouse.xy / iResolution.xy;
    if (iMouse.xy == iMouse.zw) shift += sin(iTime + vec2(0.0,pi*0.5));
    for (int i = 0; i < 18; i++)
    {
        z = collatz(z, shift);
    }
    float hue = atan(z.z,z.w);
    float val = 1.0/(1.0+0.0000000000001*dot(z.xy,z.xy));
    float sat = 1.0-1.0/(1.0+0.000000001*dot(z.zw,z.zw));
	gl_FragColor = vec4(hsv2rgb(vec3(hue+iTime,sat,val)),1.0);
    //gl_FragColor = vec4(pow(getcol(hue),vec3(val)),1.0);
      gl_FragColor.a = length(gl_FragColor.rgb); //*6.28318)
}